uniform float exposure;
uniform float decay;
uniform float density;
uniform float weight;
uniform vec2 lightPositionOnScreen;

uniform sampler2D 	firstPass;
uniform sampler2D 	lum;

varying vec2 	texcoord;
uniform vec3 	sunColor;
uniform int NUM_SAMPLES;
//uniform vec4 epsilon;

void main()
{	
 	vec2 deltaTextCoord = vec2( texcoord.st - lightPositionOnScreen.xy );
 	vec2 textCoo = texcoord.st;
 	deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
 	float illuminationDecay = 1.0;
	vec4 sample;
	vec3 acc=vec3(0.0,0.0,0.0);
	float lumColor=texture2D(lum, texcoord.st).r;
 	for(int i=0; i < NUM_SAMPLES ; i++)
  	{
		textCoo -= deltaTextCoord;
		sample = texture2D(firstPass, textCoo);// - epsilon;
		acc += sample.xyz * illuminationDecay * weight;// * sample.a;
		illuminationDecay *= decay;
 	}
	gl_FragColor.rgb = max(acc*exposure*(1.0/(lumColor + 0.001)),vec3(0.0));
}